@extends('layouts.app')

@section('title', 'Purchase Details - ' . $transaction->package->name)

@section('content')
<div class="container">
    <div class="purchase-detail">
        <!-- Back Button -->
        <div class="back-navigation">
            <a href="{{ route('store.purchase-history') }}" class="back-btn">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
                </svg>
                Back to Purchase History
            </a>
        </div>

        <!-- Transaction Header -->
        <div class="transaction-header">
            <div class="transaction-title">
                <h1>Purchase Details</h1>
                <div class="transaction-meta">
                    <span class="transaction-date">{{ $transaction->created_at->format('F d, Y \a\t H:i') }}</span>
                    <span class="status-badge {{ $transaction->status_badge_class }}">
                        {{ ucfirst($transaction->status) }}
                    </span>
                </div>
            </div>
            
            @if($transaction->status === 'completed')
            <div class="transaction-actions">
                <button class="btn btn-secondary" onclick="downloadReceipt('{{ $transaction->id }}')">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                        <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
                    </svg>
                    Download Receipt
                </button>
                <button class="btn btn-primary" onclick="copyTransactionId('{{ $transaction->transaction_id ?? $transaction->uuid }}')">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/>
                        <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/>
                    </svg>
                    Copy Transaction ID
                </button>
            </div>
            @endif
        </div>

        <div class="detail-grid">
            <!-- Package Information -->
            <div class="detail-card package-card">
                <div class="card-header">
                    <h3>Package Information</h3>
                </div>
                <div class="card-content">
                    <div class="package-overview">
                        <div class="package-icon">
                            @switch($transaction->package->type)
                                @case('vip')
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                        <path d="M5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"/>
                                    </svg>
                                    @break
                                @case('money')
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"/>
                                        <path d="M0 4a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1V4zm3 0a2 2 0 0 1-2 2v4a2 2 0 0 1 2 2h10a2 2 0 0 1 2-2V6a2 2 0 0 1-2-2H3z"/>
                                    </svg>
                                    @break
                                @case('job')
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8.5 1.5A1.5 1.5 0 0 1 10 0h4a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h4a1.5 1.5 0 0 1 1.5 1.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1a1.5 1.5 0 0 1-1.5 1.5H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h4a.5.5 0 0 0 .5-.5z"/>
                                    </svg>
                                    @break
                                @default
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492z"/>
                                    </svg>
                            @endswitch
                        </div>
                        <div class="package-info">
                            <h4>{{ $transaction->package->name }}</h4>
                            <p class="package-type">{{ ucfirst($transaction->package->type) }} Package</p>
                            <p class="package-description">{{ $transaction->package->description }}</p>
                        </div>
                    </div>

                    @if($transaction->package->features && count($transaction->package->features) > 0)
                    <div class="package-features">
                        <h5>Package Features</h5>
                        <ul>
                            @foreach($transaction->package->features as $feature)
                                <li>
                                    {{ $feature }}
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Transaction Details -->
            <div class="detail-card transaction-card">
                <div class="card-header">
                    <h3>Transaction Details</h3>
                </div>
                <div class="card-content">
                    <div class="detail-grid-items">
                        <div class="detail-item">
                            <span class="label">Transaction ID</span>
                            <span class="value">{{ $transaction->transaction_id ?? $transaction->uuid }}</span>
                        </div>

                        <div class="detail-item">
                            <span class="label">Status</span>
                            <span class="value">
                                <span class="status-badge {{ $transaction->status_badge_class }}">
                                    {{ ucfirst($transaction->status) }}
                                </span>
                            </span>
                        </div>

                        <div class="detail-item">
                            <span class="label">Payment Method</span>
                            <span class="value payment-method">
                                @if($transaction->payment_method === 'stripe')
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm2 3.5A1.5 1.5 0 0 1 5.5 2h5A1.5 1.5 0 0 1 12 3.5v1A1.5 1.5 0 0 1 10.5 6h-5A1.5 1.5 0 0 1 4 4.5v-1z"/>
                                    </svg>
                                    Credit/Debit Card
                                @else
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M14.06 3.713c.12-1.071-.093-1.832-.702-2.526C12.628.356 11.312 0 9.626 0H4.734a.7.7 0 0 0-.691.59L2.005 13.509a.42.42 0 0 0 .415.486h2.756l-.202 1.28a.628.628 0 0 0 .62.726H8.14c.429 0 .793-.31.862-.731l.025-.13.48-3.043.016-.102.106-.1c.121-.124.328-.196.517-.196h.75c2.1 0 3.76-.48 4.244-1.871.164-.474.26-.94.28-1.372.12-1.244-.254-2.103-1.01-2.763-.32-.284-.71-.45-1.128-.571z"/>
                                    </svg>
                                    PayPal
                                @endif
                            </span>
                        </div>

                        @if($transaction->server)
                        <div class="detail-item">
                            <span class="label">Server</span>
                            <span class="value">{{ $transaction->server->name }}</span>
                        </div>
                        @endif

                        <div class="detail-item">
                            <span class="label">Purchase Date</span>
                            <span class="value">{{ $transaction->created_at->format('M d, Y \a\t H:i') }}</span>
                        </div>

                        @if($transaction->status === 'completed' && $transaction->updated_at != $transaction->created_at)
                        <div class="detail-item">
                            <span class="label">Completed Date</span>
                            <span class="value">{{ $transaction->updated_at->format('M d, Y \a\t H:i') }}</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Payment Summary -->
            <div class="detail-card payment-card">
                <div class="card-header">
                    <h3>Payment Summary</h3>
                </div>
                <div class="card-content">
                    <div class="payment-breakdown">
                        @if($transaction->discount_amount > 0)
                        <div class="payment-item">
                            <span class="label">Original Price</span>
                            <span class="value original">£{{ number_format($transaction->original_amount, 2) }}</span>
                        </div>

                        @if($transaction->coupon)
                        <div class="payment-item discount">
                            <span class="label">
                                Coupon Applied
                                <span class="coupon-code">{{ $transaction->coupon->code }}</span>
                            </span>
                            <span class="value savings">-£{{ number_format($transaction->discount_amount, 2) }}</span>
                        </div>
                        @else
                        <div class="payment-item discount">
                            <span class="label">Discount Applied</span>
                            <span class="value savings">-£{{ number_format($transaction->discount_amount, 2) }}</span>
                        </div>
                        @endif
                        @endif

                        <div class="payment-item total">
                            <span class="label">Total Paid</span>
                            <span class="value amount">£{{ number_format($transaction->amount, 2) }}</span>
                        </div>
                    </div>

                    @if($transaction->discount_amount > 0)
                    <div class="savings-highlight">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M6 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm-1 0a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0z"/>
                            <path d="M2 1h4.586a1 1 0 0 1 .707.293l7 7a1 1 0 0 1 0 1.414l-4.586 4.586a1 1 0 0 1-1.414 0l-7-7A1 1 0 0 1 1 6.586V2a1 1 0 0 1 1-1zm0 5.586 7 7L13.586 9l-7-7H2v4.586z"/>
                        </svg>
                        You saved £{{ number_format($transaction->discount_amount, 2) }} ({{ $transaction->discount_percentage }}%)
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Additional Actions -->
        <div class="additional-actions">
            <div class="action-group">
                <h4>Need Help?</h4>
                <p>If you have any issues with your purchase or need support, contact our team.</p>
                <div class="action-buttons">
                    <a href="#" class="btn btn-outline">Contact Support</a>
                    <a href="{{ route('store.index') }}" class="btn btn-primary">Continue Shopping</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="copy-notification" class="copy-notification">
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
        <path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.061L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/>
    </svg>
    Transaction ID copied to clipboard!
</div>
@endsection

@push('scripts')
<script>
    function copyTransactionId(transactionId) {
        navigator.clipboard.writeText(transactionId).then(function() {
            showNotification();
        }).catch(function(err) {
            console.error('Could not copy text: ', err);
        });
    }

    function downloadReceipt(transactionId) {
        window.open(`/store/purchase/${transactionId}/receipt`, '_blank');
    }

    function showNotification() {
        const notification = document.getElementById('copy-notification');
        notification.classList.add('show');
        
        setTimeout(() => {
            notification.classList.remove('show');
        }, 3000);
    }
</script>
@endpush